'use strict';

function ModifyLoanCtrl($scope, BanksList){
    var elementId = "#modal-chattel-modify-loan";

    $scope.cbso = false;
    $scope.title = '';
    $scope.new_amount = 0;

    $scope.CurrentAccount = BanksList.getCurrentAccount();

    $scope.maxValue = 0;

    $scope.$on('Chattel:modifyLoan', function(event, cbso){
        $scope.cbso = cbso;
        $scope.new_amount = cbso.value;
        $scope.title = BanksList.getOptionFullName(cbso.option_id);
        $scope.maxValue = 5000000;

        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal({
            backdrop: 'static'
            ,keyboard: false
            ,show: true
        });
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.modifyLoan = function(){
        var difference = ( parseFloat($scope.new_amount) - $scope.cbso.value );
        $scope.cbso.value = parseFloat($scope.new_amount);
        $scope.cbso._operation = 'MODIFY_LOAN';
        $scope.CurrentAccount.company_bank_service_options[0].value += difference;
        $scope.closeModal();
    }

}

ModifyLoanCtrl.$inject = ['$scope', 'BanksList'];
